package it.eng.eremita.jpa.util;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import it.eng.eremita.graphql.types.other.Filter;
import it.eng.eremita.graphql.types.other.OrderBy;

public class QueryBuilder {
	
	public static String[] operatori = {"=","<>",">","<",">=","<=","LIKE","ILIKE"};
	
	Collection<Filter> filtri;
	String tabella;
	Map<String,String> tipiArgomenti;
	OrderBy orderby;
	String condizioniAggiuntive;
	
	public QueryBuilder(String tab, Collection<Filter> f, Map<String,String> tipi, OrderBy o) {
		tabella = tab;
		filtri = f;
		tipiArgomenti = tipi;
		orderby = o;
		condizioniAggiuntive = null;
	}
	
	public QueryBuilder(String tab, Collection<Filter> f, Map<String,String> tipi, OrderBy o, String add) {
		tabella = tab;
		filtri = f;
		tipiArgomenti = tipi;
		orderby = o;
		condizioniAggiuntive = add;
	}
	
	
	public String baseString() {
		return "select * from " + tabella + " where 1=1";
	}
	
	public String countString() {
		return "select count(*) from " + tabella + " where 1=1";
	}
	
	public boolean isFilterAllowed(Filter f) {
		if (f.getOperator()==null) return false;
		boolean found = false;
		for (String op : operatori) if (f.getOperator().toUpperCase().equals(op)) found = true;
		if (!found) return false;
		
		if (tipiArgomenti==null) return true;
		return (tipiArgomenti.containsKey(f.getKey()));
	}
	
	public Object processValue(Filter f) {
		if (f.getValue()==null) return null;
		
		if (tipiArgomenti!=null) {
			for (Entry<String,String> e : tipiArgomenti.entrySet()) {
				if (e.getKey().equals(f.getKey())) {
					String transformer = e.getValue();
					if ("string".equals(e.getValue())) return (f.getValue()!=null && f.getOperator().toLowerCase().equals("ilike")?
							f.getValue().toUpperCase():f.getValue());
					if ("long".equals(e.getValue())) return Long.parseLong(f.getValue());
					if ("int".equals(e.getValue())) return Integer.parseInt(f.getValue());
					
				}
			}
		}
		return f.getValue();
	}
	
	public String filterQuery(Filter f, List<Object> parameters) {
		
		if (f==null) return "";
		if (f.getValue()==null && f.getKey()==null) return "";
		if (!isFilterAllowed(f)) return "";
		
		Object o = f.getValue();
		try {
			o = processValue(f);
		} catch (Exception e) { return "";}
		
		String key = f.getKey();
		String operator = f.getOperator();
		if ("ilike".equals(f.getOperator().toLowerCase())) {
			key = "upper("+key+")";
			operator = "like";
		}
		
		if ("like".equals(operator.toLowerCase())) {
			o = "%"+o.toString()+"%";
		}
		
		if (f.getValue()==null) return " and "+key+" is null";
		
		parameters.add(o);
		return " and " + key + " " + operator + " ?";
	}
	
	public String orderByQuery() {
		if (orderby==null) return "";
		if (orderby.getCampo()==null) return "";
		if (tipiArgomenti!=null && !tipiArgomenti.containsKey(orderby.getCampo())) return "";
		String s = " order by "+orderby.getCampo();
		if (orderby.getAsc()!=null) {
			if ("asc".equals(orderby.getAsc()) || "desc".equals(orderby.getAsc())) s+=" " +orderby.getAsc();
		}
		return s;
	}
	
	public String makeQuery(List<Object> parameters) {
		String s = baseString();
		if (filtri!=null)
			for (Filter f : filtri) {
				s += filterQuery(f,parameters);
			}
		if (condizioniAggiuntive!=null && !condizioniAggiuntive.equals(""))
			s+=" and ("+condizioniAggiuntive+")";
		s += orderByQuery();
		
		return s;
	}
	
	public String makeCountQuery(List<Object> parameters) {
		String s = countString();
		if (filtri==null) return s;
		for (Filter f : filtri) {
			s += filterQuery(f,parameters);
		}
		if (condizioniAggiuntive!=null && !condizioniAggiuntive.equals(""))
			s+=" and ("+condizioniAggiuntive+")";
		return s;
	}

}
